function z = find_tfp_scale(py,l,eta_data,e_normalized,model)

% Load model parameters
ind1_inv    = model.ind1_inv;
ind2_inv    = model.ind2_inv;
eta_x       = model.eta_x;
epsilon_x   = model.epsilon_x;
rho_x       = model.rho_x;
zeta_x      = model.zeta_x;
ind1_mat    = model.ind1_mat;
ind2_mat    = model.ind2_mat;
eta_m       = model.eta_m;
epsilon_m   = model.epsilon_m;
rho_m       = model.rho_m;
zeta_m      = model.zeta_m;
gamma_y     = model.gamma_y;
beta        = model.beta;
delta       = model.delta;
alpha       = model.alpha;

% STEP 1: solve p^x = P^X(p^y)
px = NaN(5,1);
for j = 1:5
    temp_sum = 0;
    for i = ind1_inv
        temp_sum = temp_sum + eta_x(i,j)^epsilon_x(j)*py(i)^(1-epsilon_x(j));
    end
    temp_sum = temp_sum^(rho_x(j)/(1-epsilon_x(j)));

    temp_prod = 1;
    for i = ind2_inv
        temp_prod = temp_prod*py(i)^(zeta_x(i,j)*(1-rho_x(j)));
    end
    px(j) = temp_sum*temp_prod;
end


% STEP 2: solve p^m = P^(p^y)
pm = NaN(5,1);
for j = 1:5
    temp_sum = 0;
    for i = ind1_mat
        temp_sum = temp_sum + eta_m(i,j)^epsilon_m(j)*py(i)^(1-epsilon_m(j));
    end
    temp_sum = temp_sum^(rho_m(j)/(1-epsilon_m(j)));

    temp_prod = 1;
    for i = ind2_mat
        temp_prod = temp_prod*py(i)^(zeta_m(i,j)*(1-rho_m(j)));
    end
    pm(j) = temp_sum*temp_prod;
end

% STEP 3: solve for p^v from p^y = P^Y(p^v,p^m) 
pv   = NaN(5,1);
for j = 1:5
    pv(j) = (py(j)/pm(j)^(1-gamma_y(j)))^(1/gamma_y(j));
end


% STEP 4: solve for u from Euler equation
u = px.*(1/beta - 1 + delta);

% Compute TFP consistent with normalized demand
kappa = (1./alpha.^alpha./(1-alpha).^(1-alpha));
Vtilde = (pv.*kappa).^(1./(1-alpha)).*(alpha./u).^(alpha./(1-alpha)).*l;

ztilde = e_normalized./((1./eta_data).*Vtilde);

z = ztilde.^(1-alpha);
